# Code of submission O4608

This repository contains the code required to train/evaluate a model on CIFAR100/Tiny-ImageNet/DermaMNIST. The datasets need to be downloaded to a 'dataset/' folder.

## Installation

Create a pip environment with all the requirements and activate it:

```setup1
pip install -r requirements.txt
```

## Training from scratch and evaluate

Use this command to run an example experiment on CIFAR100, using Wide-ResNet-28-10 and one of the secondary AUCOCLoss configurations (lambda = 10 here):

```train
python -u main.py --base_config_file cifar100_wide_resnet_28 --loss_config_file auc_secondary_bw_l10
```

## Folder's structure:
- The main folder contains 'main.py' to run the in-distribution experiments, 'eval_ood.py' to run the OOD evaluations and the requirements file to create the environment;
- 'data/' contains the dataloader files required to load the datasets;
- 'loss_functions/' contains the implementation of both the baselines and AUCOCLoss as well as the function to select which method to use;
- 'metrics/' contains the code to implement the evaluation metrics as well as useful plots;
- 'src/' contains the code to implement the training and evaluation functionalities;
- 'utils/' contains various auxiliary functions, e.g. to read files, load models, compute temperature for temperature scaling;

